<?php
/**
 * Created by PhpStorm.
 * User: Lupup
 * Date: 13/06/2023
 * Time: 22:39
 */

namespace App\Security\Voter;

use App\Entity\User;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\Authorization\Voter\The;
use Symfony\Component\Security\Core\Authorization\Voter\Voter;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Security\Core\User\UserInterface;

class UsuarioVoter extends Voter
{
    const  EDIT = 'USER_EDIT';
    const  DELETE = 'USER_DELETE';

    private $security;

    public function __construct(Security $security)
    {
         $this->security = $security;
    }

    /**
     * Determines if the attribute and subject are supported by this voter.
     *
     * @param $subject The subject to secure, e.g. an object the user wants to access or any other PHP type
     */
    protected function supports(string $attribute,$usuario): bool
    {
        if(!in_array($attribute,[self::EDIT,self::DELETE])){
           return false;
        }
        if(!$usuario instanceof User){
           return false;
        }

        return true;

    }

    /**
     * Perform a single access check operation on a given attribute, subject and token.
     * It is safe to assume that $attribute and $subject already passed the "supports()" method check.
     */
    protected function voteOnAttribute(string $attribute,$usuario, TokenInterface $token): bool
    {
        $user = $token->getUser();
        if(!$user instanceof UserInterface){
             return false;
        }

        if($this->security->isGranted('ROLE_ADMIN')){
            return true;
        }

        switch ($attribute){
            case self::EDIT:
                return $this->canEdit();
                break;
            case self::DELETE:
                return $this->canDelete();
                break;
        }
        //return true;
    }

    private function canEdit(){
        return $this->security->isGranted('ROLE_CLIENTE_ADMIN');
    }
    private function canDelete(){
        return $this->security->isGranted('ROLE_ADMIN');
    }

}