<?php

namespace App\Repository;

use App\Entity\TransferenciaPedido;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<TransferenciaPedido>
 *
 * @method TransferenciaPedido|null find($id, $lockMode = null, $lockVersion = null)
 * @method TransferenciaPedido|null findOneBy(array $criteria, array $orderBy = null)
 * @method TransferenciaPedido[]    findAll()
 * @method TransferenciaPedido[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class TransferenciaPedidoRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, TransferenciaPedido::class);
    }

    public function save(TransferenciaPedido $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(TransferenciaPedido $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function findAlltransferenciaProvincia($value){
        return $this->getEntityManager()
            ->createQuery("SELECT trans.id, trans.createdAt,p.id AS id_pedido, trans.updateAt,dep.nome AS nome_departamento, e.nome AS nome_estado, f.nome AS nome_fase, 
            t.nome AS nome_tipo, p.updateAt AS update_pedido,p.createdAt AS created_pedido,p.tranferido, u.nome AS nome_user,b.nome AS nome_bairro,
            c.nome AS nome_comuna,m.nome AS nome_municipio,prov.nome AS nome_provincia 
            FROM App:TransferenciaPedido trans 
            JOIN trans.pedido p  
            JOIN trans.departamento dep 
            JOIN p.estado_pedido e 
            JOIN p.fase_pedido f 
            JOIN p.tipo_pedido t 
            JOIN p.usuario u 
            JOIN u.bairro b 
            JOIN b.comuna c 
            JOIN c.municipio m 
            JOIN m.provincia prov 
            WHERE prov = :val 
            ORDER BY p.createdAt")
            ->setParameter('val',$value);
    }

    public function findByAllTransferenciaDepartamento($value,$value2): array
    {
        return $this->createQueryBuilder('t')
            ->where('t.departamento = :val and prov = :val2')
            //->andWhere('trans.departamento = :val')
            ->join('t.pedido','ped')
            ->join('t.departamento','dep')
            ->join('ped.fase_pedido','fase')
            ->join('ped.estado_pedido','estado')
            ->join('ped.usuario','user')
            ->join('user.bairro','bai')
            ->join('bai.comuna','com')
            ->join('com.municipio','mun')
            ->join('mun.provincia','prov')
            ->setParameter('val', $value)
            ->setParameter('val2', $value2)
            ->orderBy('t.id', 'ASC')
            ->setMaxResults(10)
            ->getQuery()
            ->getResult()
            ;
    }

//    /**
//     * @return TransferenciaPedido[] Returns an array of TransferenciaPedido objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('t')
//            ->andWhere('t.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('t.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?TransferenciaPedido
//    {
//        return $this->createQueryBuilder('t')
//            ->andWhere('t.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
