<?php

namespace App\Repository;

use App\Entity\TipoPedido;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<TipoPedido>
 *
 * @method TipoPedido|null find($id, $lockMode = null, $lockVersion = null)
 * @method TipoPedido|null findOneBy(array $criteria, array $orderBy = null)
 * @method TipoPedido[]    findAll()
 * @method TipoPedido[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class TipoPedidoRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, TipoPedido::class);
    }

    public function save(TipoPedido $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(TipoPedido $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function findAllTipoPedidos(){

        return $this->getEntityManager()
            ->createQuery('SELECT e.id, e.nome, e.createdAt, e.updateAt,e.isAtivo FROM App:TipoPedido e');
    }
//    /**
//     * @return TipoPedido[] Returns an array of TipoPedido objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('t')
//            ->andWhere('t.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('t.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?TipoPedido
//    {
//        return $this->createQueryBuilder('t')
//            ->andWhere('t.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
