<?php

namespace App\Repository;

use App\Entity\RequisicaoExtintor;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<RequisicaoExtintor>
 *
 * @method RequisicaoExtintor|null find($id, $lockMode = null, $lockVersion = null)
 * @method RequisicaoExtintor|null findOneBy(array $criteria, array $orderBy = null)
 * @method RequisicaoExtintor[]    findAll()
 * @method RequisicaoExtintor[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class RequisicaoExtintorRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, RequisicaoExtintor::class);
    }

    public function save(RequisicaoExtintor $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(RequisicaoExtintor $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

//    /**
//     * @return RequisicaoExtintor[] Returns an array of RequisicaoExtintor objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('r')
//            ->andWhere('r.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('r.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?RequisicaoExtintor
//    {
//        return $this->createQueryBuilder('r')
//            ->andWhere('r.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
