<?php

namespace App\Repository;

use App\Entity\Pedido;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Pedido>
 *
 * @method Pedido|null find($id, $lockMode = null, $lockVersion = null)
 * @method Pedido|null findOneBy(array $criteria, array $orderBy = null)
 * @method Pedido[]    findAll()
 * @method Pedido[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class PedidoRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Pedido::class);
    }

    public function save(Pedido $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(Pedido $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function  findByAllPedidoProvincias($value){
        return $this->getEntityManager()
            ->createQuery("SELECT e.nome AS nome_estado, f.nome AS nome_fase, 
            t.nome AS nome_tipo, p.updateAt,p.createdAt, u.nome AS nome_user,b.nome AS nome_bairro,
            c.nome AS nome_comuna,m.nome AS nome_municipio,prov.nome AS nome_provincia 
            FROM App:Pedido p 
            JOIN p.estado_pedido e 
            JOIN p.fase_pedido f 
            JOIN p.tipo_pedido t 
            JOIN p.usuario u 
            JOIN u.bairro b 
            JOIN b.comuna c 
            JOIN c.municipio m 
            JOIN m.provincia prov 
            WHERE prov = :val 
            ORDER BY p.createdAt")
            ->setParameter('val',$value);

    }

//    /**
//     * @return Pedido[] Returns an array of Pedido objects
//     */
    public function findByPedidoUser($value): array
    {
        return $this->createQueryBuilder('p')
            ->andWhere('p.usuario = :val')
            ->setParameter('val', $value)
            ->orderBy('p.id', 'ASC')
            ->setMaxResults(10)
            ->getQuery()
            ->getResult()
        ;
    }

//    /**
//     * @return Pedido[] Returns an array of Pedido objects
//     */
    public function findByAllPedidoProvincia($value): array
    {
        return $this->createQueryBuilder('p')
            ->andWhere('mun.provincia = :val')
            ->join('p.usuario','user')
            ->join('user.bairro','bai')
            ->join('bai.comuna','co')
            ->join('co.municipio','mun')
            ->join('mun.provincia','prov')
            ->setParameter('val', $value)
            ->orderBy('p.id', 'ASC')
            ->setMaxResults(10)
            ->getQuery()
            ->getResult()
            ;
    }

//    public function findOneBySomeField($value): ?Pedido
//    {
//        return $this->createQueryBuilder('p')
//            ->andWhere('p.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
