<?php

namespace App\Repository;

use App\Entity\PedidoDepartamento;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<PedidoDepartamento>
 *
 * @method PedidoDepartamento|null find($id, $lockMode = null, $lockVersion = null)
 * @method PedidoDepartamento|null findOneBy(array $criteria, array $orderBy = null)
 * @method PedidoDepartamento[]    findAll()
 * @method PedidoDepartamento[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class PedidoDepartamentoRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, PedidoDepartamento::class);
    }

    public function save(PedidoDepartamento $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(PedidoDepartamento $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }


    public function findByAllPedidoDepartamento($value,$value2): array
    {
        return $this->createQueryBuilder('p')
            ->where('p.departamento = :val and prov = :val2')
            //->andWhere('trans.departamento = :val')
            ->join('p.pedidoTransferido','trans')
            ->join('trans.pedido','ped')
            ->join('trans.departamento','dep')
            ->join('ped.tipo_pedido','tipo')
            ->join('ped.fase_pedido','fase')
            ->join('ped.estado_pedido','estado')
            ->join('ped.usuario','user')
            ->join('user.bairro','bai')
            ->join('bai.comuna','com')
            ->join('com.municipio','mun')
            ->join('mun.provincia','prov')
            ->setParameter('val', $value)
            ->setParameter('val2', $value2)
            ->orderBy('p.id', 'ASC')
            ->setMaxResults(10)
            ->getQuery()
            ->getResult()
            ;
    }



//    /**
//     * @return PedidoDepartamento[] Returns an array of PedidoDepartamento objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('p')
//            ->andWhere('p.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('p.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?PedidoDepartamento
//    {
//        return $this->createQueryBuilder('p')
//            ->andWhere('p.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
