<?php

namespace App\Repository;

use App\Entity\FasePedido;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<FasePedido>
 *
 * @method FasePedido|null find($id, $lockMode = null, $lockVersion = null)
 * @method FasePedido|null findOneBy(array $criteria, array $orderBy = null)
 * @method FasePedido[]    findAll()
 * @method FasePedido[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class FasePedidoRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, FasePedido::class);
    }

    public function save(FasePedido $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(FasePedido $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function findAllFasePedidos(){

        return $this->getEntityManager()
            ->createQuery('SELECT e.id, e.nome, e.createdAt, e.updateAt,e.isAtivo FROM App:FasePedido e');
    }
//    /**
//     * @return FasePedido[] Returns an array of FasePedido objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('f')
//            ->andWhere('f.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('f.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

    public function findOneByNome($value): ?FasePedido
    {
        return $this->createQueryBuilder('f')
            ->andWhere('f.nome = :val')
            ->setParameter('val', $value)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
}
