<?php

namespace App\Repository;

use App\Entity\EstadoPedido;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<EstadoPedido>
 *
 * @method EstadoPedido|null find($id, $lockMode = null, $lockVersion = null)
 * @method EstadoPedido|null findOneBy(array $criteria, array $orderBy = null)
 * @method EstadoPedido[]    findAll()
 * @method EstadoPedido[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class EstadoPedidoRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, EstadoPedido::class);
    }

    public function save(EstadoPedido $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(EstadoPedido $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function findAllEstados(){

        return $this->getEntityManager()
            ->createQuery('SELECT e.id, e.nome, e.createdAt, e.updateAt,e.isAtivo FROM App:EstadoPedido e');
    }

//    /**
//     * @return EstadoPedido[] Returns an array of EstadoPedido objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('e')
//            ->andWhere('e.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('e.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

    public function findOneByNome($value): ?EstadoPedido
    {
        return $this->createQueryBuilder('e')
            ->andWhere('e.nome = :val')
            ->setParameter('val', $value)
            ->getQuery()
            ->getOneOrNullResult()
        ;
    }
}
