<?php

namespace App\Repository;

use App\Entity\EstadoFinalPedido;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<EstadoFinalPedido>
 *
 * @method EstadoFinalPedido|null find($id, $lockMode = null, $lockVersion = null)
 * @method EstadoFinalPedido|null findOneBy(array $criteria, array $orderBy = null)
 * @method EstadoFinalPedido[]    findAll()
 * @method EstadoFinalPedido[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class EstadoFinalPedidoRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, EstadoFinalPedido::class);
    }

    public function save(EstadoFinalPedido $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(EstadoFinalPedido $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function findByAllEstadoFinalPedido($value): array
    {
        return $this->createQueryBuilder('e')
            ->andWhere('trans.pedido = :val')
            ->join('e.pedidoTransferido','trans')
            ->join('trans.pedido','ped')
            ->join('ped.usuario','user')
            ->join('user.bairro','bai')
            ->join('bai.comuna','co')
            ->join('co.municipio','mun')
            ->join('mun.provincia','prov')
            ->setParameter('val', $value)
            ->orderBy('e.id', 'ASC')
            ->setMaxResults(1)
            ->getQuery()
            ->getResult()
            ;
    }

//    /**
//     * @return EstadoFinalPedido[] Returns an array of EstadoFinalPedido objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('e')
//            ->andWhere('e.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('e.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?EstadoFinalPedido
//    {
//        return $this->createQueryBuilder('e')
//            ->andWhere('e.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
