<?php

namespace App\Repository;

use App\Entity\Comuna;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Comuna>
 *
 * @method Comuna|null find($id, $lockMode = null, $lockVersion = null)
 * @method Comuna|null findOneBy(array $criteria, array $orderBy = null)
 * @method Comuna[]    findAll()
 * @method Comuna[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class ComunaRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Comuna::class);
    }

    public function save(Comuna $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(Comuna $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function findAllComunas(): array
    {
        return $this->getEntityManager()
            ->createQuery('SELECT f.id, f.nome,f.updateAte,f.isAtivo,m.nome AS nome_municipio,p.nome AS nome_provincia
            FROM App:Comuna f
            JOIN f.municipio m
            JOIN m.provincia p
            ')

            ->getResult()
            ;
    }

//    /**
//     * @return Comuna[] Returns an array of Comuna objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('c')
//            ->andWhere('c.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('c.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?Comuna
//    {
//        return $this->createQueryBuilder('c')
//            ->andWhere('c.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
