<?php

namespace App\Repository;

use App\Entity\Bairro;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Bairro>
 *
 * @method Bairro|null find($id, $lockMode = null, $lockVersion = null)
 * @method Bairro|null findOneBy(array $criteria, array $orderBy = null)
 * @method Bairro[]    findAll()
 * @method Bairro[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class BairroRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Bairro::class);
    }

    public function save(Bairro $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(Bairro $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function findAllBairros(): array
    {
        return $this->getEntityManager()
            ->createQuery('SELECT b.id, b.nome,b.updateAt,b.isAtivo,c.nome AS nome_comuna,
             m.nome AS nome_municipio, p.nome AS nome_provincia
            FROM App:Bairro b
            JOIN b.comuna c
            JOIN c.municipio m
            JOIN m.provincia p
            ')

            ->getResult()
            ;
    }

//    /**
//     * @return Bairro[] Returns an array of Bairro objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('b')
//            ->andWhere('b.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('b.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?Bairro
//    {
//        return $this->createQueryBuilder('b')
//            ->andWhere('b.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
