<?php

namespace App\Form;

use App\Entity\Bairro;
use App\Entity\Municipio;
use App\Entity\Sexo;
use App\Entity\User;
use App\Repository\BairroRepository;
use App\Repository\MunicipioRepository;
use App\Repository\SexoRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class UsuarioFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nome')
            ->add('nif')
            ->add('telefone')
            ->add('sexo', EntityType::class,[
                'class'=> Sexo::class,
                'choice_label' => 'nome',
                'label' => 'Sexo',
                'query_builder' => function(SexoRepository $sexoRepository){
                    return $sexoRepository->createQueryBuilder('m')
                        ->orderBy('m.nome','ASC');
                }
            ])
            ->add('bairro',EntityType::class,[
                'class'=> Bairro::class,
                'choice_label' => 'nome',
                'label' => 'Bairro',
                'query_builder' => function(BairroRepository $bairroRepository){
                    return $bairroRepository->createQueryBuilder('m')
                        ->orderBy('m.nome','ASC');
                }
            ])
            //->add('documentos', FileType::class,[
              //  'label' => false,
               // 'multiple' =>true,
               // 'mapped' => false,
               // 'required' => false
            //])


        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => User::class,
        ]);
    }
}
