<?php

namespace App\Form;

use App\Entity\Departamento;
use App\Entity\Pedido;
use App\Entity\TransferenciaPedido;
use App\Repository\DepartamentoRepository;
use App\Repository\PedidoRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TransferenciaPedidoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            //->add('pedido',)
            ->add('departamento',EntityType::class,[
                'class'=> Departamento::class,
                'choice_label' => 'nome',
                'label' => 'Departamento',
                'query_builder' => function(DepartamentoRepository $departamentoRepository){
                    return $departamentoRepository-> createQueryBuilder('d')
                        ->orderBy('d.nome','ASC');
                }
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => TransferenciaPedido::class,
        ]);
    }
}
