<?php

namespace App\Form;

use App\Entity\Departamento;
use App\Entity\User;
use App\Repository\DepartamentoRepository;
use phpDocumentor\Reflection\Types\Boolean;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class RoleUsuarioType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            //->add('email')
            ->add('roles', ChoiceType::class,[
                'choices'=> array(
                    'Cliente' => 'ROLE_CLIENTE_ADMIN',
                    'Administrador' => 'ROLE_ADMIN',
                    'Secretário(a)' => 'ROLE_SECRE_ADMIN',
                    'Técnico(a) de departamento' => 'ROLE_TECNICO_DEPART_ADMIN'
                )
            ])
            ->add('departamento',EntityType::class,[
                'class'=> Departamento::class,
                'choice_label' => 'nome',
                'label' => 'Departamento',
                'query_builder' => function(DepartamentoRepository $departamentoRepository){
                    return $departamentoRepository->createQueryBuilder('d')
                        ->orderBy('d.nome','ASC');
                }
            ])
            ->add('isAtivo')
            //->add('isAtivo',)
            //->add('nome')
            //->add('nif')
            //->add('telefone')
            //->add('endereco')
        ;
        $builder->get('roles')
            ->addModelTransformer(new CallbackTransformer(
                function ($rolesArray) {
                    // transform the array to a string
                    return count($rolesArray)? $rolesArray[0]: null;
                },
                function ($rolesString) {
                    // transform the string back to an array
                    return [$rolesString];
                }
            ));

    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => User::class,
        ]);
    }
}
