<?php

namespace App\Form;

use App\Entity\Pedido;
use App\Entity\TipoPedido;
use App\Repository\TipoPedidoRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PedidoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('tipo_pedido',EntityType::class,[
                'class'=> TipoPedido::class,
                'choice_label' => 'nome',
                'label' => 'Tipo de requisição',
                'query_builder' => function(TipoPedidoRepository $tipoPedidoRepository){
                    return $tipoPedidoRepository->createQueryBuilder('m')
                        ->orderBy('m.nome','ASC');
                }
            ])
            //->add('estado_pedido')
            //->add('fase_pedido')
            //->add('usuario')
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Pedido::class,
        ]);
    }
}
