<?php

namespace App\Form;

use App\Entity\Municipio;
use App\Entity\Provincia;
use App\Repository\ProvinciaRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class MunicipioType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nome')
            //->add('ativo_is')
            ->add('provincia',EntityType::class,[
                'class'=> Provincia::class,
                'choice_label' => 'nome',
                'label' => 'Provincia',
                'query_builder' => function(ProvinciaRepository $provinciaRepository){
                    return $provinciaRepository->createQueryBuilder('m')
                        ->orderBy('m.nome','ASC');
                }
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Municipio::class,
        ]);
    }
}
