<?php

namespace App\Form;

use App\Entity\Extintor;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class MudarEstadoExtintorType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            //->add('datarequisicaoAt')
            //->add('quantidade')
            ->add('estado', ChoiceType::class,[
                'choices'=> array(
                    'Processo Pendente' => 'PENDENTE',
                    'Processo em Analise' => 'ANALISE',
                    'Processo Aprovado' => 'APROVADO'
                )
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Extintor::class,
        ]);
    }
}
