<?php

namespace App\Form;

use App\Entity\EstadoFinalPedido;
use App\Entity\Pedido;
use App\Repository\PedidoRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class EstadoFinalPedidoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('estadoPedido',ChoiceType::class,[
                'choices'=> array(
                    'Rejeitado' => 'Processo Rejeitado',
                    'Aprovado' => 'Processo Aprovado'
                )
            ])
            ->add('observacao', TextType::class)
        ;
        $builder->get('estadoPedido')
            ->addModelTransformer(new CallbackTransformer(
                function ($estadoPedidoArray) {
                    // transform the array to a string
                    return count($estadoPedidoArray)? $estadoPedidoArray[0]: null;
                },
                function ($estadoPedidoString) {
                    // transform the string back to an array
                    return [$estadoPedidoString];
                }
            ));
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => EstadoFinalPedido::class,
        ]);
    }
}
