<?php

namespace App\Form;

use App\Entity\Extintor;
use App\Entity\RequisicaoExtintor;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ChangeStatusExtintorType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            //->add('updateAt')
            //->add('usuarioAdmin')
            ->add('extintores',EntityType::class,[
                'class'=> Extintor::class,
                'choice_label' => 'nome',
                'label' => 'Categoria',
                'group_by' =>'nome',
                'query_builder' => function(CategoriaRepository $categoriaRepository){
                    return $categoriaRepository->createQueryBuilder('c')
                        ->where('c.parent IS NOT NULL')
                        ->orderBy('c.nome','ASC');
                }
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => RequisicaoExtintor::class,
        ]);
    }
}
