<?php

namespace App\Entity;

use App\Repository\TransferenciaPedidoRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: TransferenciaPedidoRepository::class)]
class TransferenciaPedido
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column]
    private ?\DateTimeImmutable $createdAt = null;

    #[ORM\Column]
    private ?\DateTimeImmutable $updateAt = null;

    #[ORM\ManyToOne(inversedBy: 'transferenciaPedidos')]
    private ?Pedido $pedido = null;

    #[ORM\ManyToOne(inversedBy: 'transferenciaPedidos')]
    private ?Departamento $departamento = null;

    #[ORM\Column]
    private ?bool $isAtivo = null;

    #[ORM\OneToMany(mappedBy: 'pedidoTransferido', targetEntity: PedidoDepartamento::class)]
    private Collection $pedidoDepartamentos;

    #[ORM\OneToMany(mappedBy: 'pedidoTransferido', targetEntity: EstadoFinalPedido::class)]
    private Collection $estadoFinalPedidos;

    public function __construct()
    {
        $this->isAtivo = true;
        $this->createdAt = new \DateTimeImmutable();
        $this->updateAt = new \DateTimeImmutable();
        $this->pedidoDepartamentos = new ArrayCollection();
        $this->estadoFinalPedidos = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->createdAt;
    }

    public function setCreatedAt(\DateTimeImmutable $createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdateAt(): ?\DateTimeImmutable
    {
        return $this->updateAt;
    }

    public function setUpdateAt(\DateTimeImmutable $updateAt): self
    {
        $this->updateAt = $updateAt;

        return $this;
    }

    public function getPedido(): ?Pedido
    {
        return $this->pedido;
    }

    public function setPedido(?Pedido $pedido): self
    {
        $this->pedido = $pedido;

        return $this;
    }

    public function getDepartamento(): ?Departamento
    {
        return $this->departamento;
    }

    public function setDepartamento(?Departamento $departamento): self
    {
        $this->departamento = $departamento;

        return $this;
    }

    public function isIsAtivo(): ?bool
    {
        return $this->isAtivo;
    }

    public function setIsAtivo(bool $isAtivo): self
    {
        $this->isAtivo = $isAtivo;

        return $this;
    }

    /**
     * @return Collection<int, PedidoDepartamento>
     */
    public function getPedidoDepartamentos(): Collection
    {
        return $this->pedidoDepartamentos;
    }

    public function addPedidoDepartamento(PedidoDepartamento $pedidoDepartamento): self
    {
        if (!$this->pedidoDepartamentos->contains($pedidoDepartamento)) {
            $this->pedidoDepartamentos->add($pedidoDepartamento);
            $pedidoDepartamento->setPedidoTransferido($this);
        }

        return $this;
    }

    public function removePedidoDepartamento(PedidoDepartamento $pedidoDepartamento): self
    {
        if ($this->pedidoDepartamentos->removeElement($pedidoDepartamento)) {
            // set the owning side to null (unless already changed)
            if ($pedidoDepartamento->getPedidoTransferido() === $this) {
                $pedidoDepartamento->setPedidoTransferido(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, EstadoFinalPedido>
     */
    public function getEstadoFinalPedidos(): Collection
    {
        return $this->estadoFinalPedidos;
    }

    public function addEstadoFinalPedido(EstadoFinalPedido $estadoFinalPedido): self
    {
        if (!$this->estadoFinalPedidos->contains($estadoFinalPedido)) {
            $this->estadoFinalPedidos->add($estadoFinalPedido);
            $estadoFinalPedido->setPedidoTransferido($this);
        }

        return $this;
    }

    public function removeEstadoFinalPedido(EstadoFinalPedido $estadoFinalPedido): self
    {
        if ($this->estadoFinalPedidos->removeElement($estadoFinalPedido)) {
            // set the owning side to null (unless already changed)
            if ($estadoFinalPedido->getPedidoTransferido() === $this) {
                $estadoFinalPedido->setPedidoTransferido(null);
            }
        }

        return $this;
    }
}
