<?php

namespace App\Entity;

use App\Repository\ProvinciaRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ProvinciaRepository::class)]
class Provincia
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 90)]
    private ?string $nome = null;

    #[ORM\OneToMany(mappedBy: 'provincia', targetEntity: Municipio::class)]
    private Collection $municipios;

    #[ORM\Column]
    private ?\DateTimeImmutable $updateAt = null;

    #[ORM\Column]
    private ?bool $isAtivo = null;

    #[ORM\Column(length: 10, nullable: true)]
    private ?string $codigoIso = null;


    public function __construct()
    {
        $this->updateAt = new \DateTimeImmutable();
        $this->isAtivo = true;
        //$this->users = new ArrayCollection();
        //$this->municipios = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNome(): ?string
    {
        return $this->nome;
    }

    public function setNome(string $nome): self
    {
        $this->nome = $nome;

        return $this;
    }

    /**
     * @return Collection<int, Municipio>
     */
    public function getMunicipios(): Collection
    {
        return $this->municipios;
    }

    public function addMunicipio(Municipio $municipio): self
    {
        if (!$this->municipios->contains($municipio)) {
            $this->municipios->add($municipio);
            $municipio->setProvincia($this);
        }

        return $this;
    }

    public function removeMunicipio(Municipio $municipio): self
    {
        if ($this->municipios->removeElement($municipio)) {
            // set the owning side to null (unless already changed)
            if ($municipio->getProvincia() === $this) {
                $municipio->setProvincia(null);
            }
        }

        return $this;
    }

    public function getUpdateAt(): ?\DateTimeImmutable
    {
        return $this->updateAt;
    }

    public function setUpdateAt(\DateTimeImmutable $updateAt): self
    {
        $this->updateAt = $updateAt;

        return $this;
    }

    public function isIsAtivo(): ?bool
    {
        return $this->isAtivo;
    }

    public function setIsAtivo(bool $isAtivo): self
    {
        $this->isAtivo = $isAtivo;

        return $this;
    }

    public function getCodigoIso(): ?string
    {
        return $this->codigoIso;
    }

    public function setCodigoIso(?string $codigoIso): self
    {
        $this->codigoIso = $codigoIso;

        return $this;
    }


}
