<?php

namespace App\Entity;

use App\Repository\PedidoRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: PedidoRepository::class)]
class Pedido
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'pedidos')]
    private ?EstadoPedido $estado_pedido = null;

    #[ORM\ManyToOne(inversedBy: 'pedidos')]
    private ?FasePedido $fase_pedido = null;

    #[ORM\ManyToOne(inversedBy: 'pedidos')]
    private ?TipoPedido $tipo_pedido = null;

    #[ORM\Column]
    private ?\DateTimeImmutable $updateAt = null;

    #[ORM\Column]
    private ?bool $isAtivo = null;

    #[ORM\OneToMany(mappedBy: 'pedido', targetEntity: TransferenciaPedido::class)]
    private Collection $transferenciaPedidos;

    #[ORM\ManyToOne(inversedBy: 'pedidos')]
    private ?User $usuario = null;

    #[ORM\Column]
    private ?\DateTimeImmutable $createdAt = null;

    #[ORM\Column(nullable: true)]
    private ?bool $tranferido = null;

    #[ORM\OneToMany(mappedBy: 'pedido', targetEntity: EstadoFinalPedido::class)]
    private Collection $estadoFinalPedidos;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $observacao = null;

    public function __construct()
    {
        $this->tranferido = false;
        $this->createdAt = new \DateTimeImmutable();
        $this->updateAt = new \DateTimeImmutable();
        $this->isAtivo = true;
        $this->transferenciaPedidos = new ArrayCollection();
        $this->estadoFinalPedidos = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEstadoPedido(): ?EstadoPedido
    {
        return $this->estado_pedido;
    }

    public function setEstadoPedido(?EstadoPedido $estado_pedido): self
    {
        $this->estado_pedido = $estado_pedido;

        return $this;
    }

    public function getFasePedido(): ?FasePedido
    {
        return $this->fase_pedido;
    }

    public function setFasePedido(?FasePedido $fase_pedido): self
    {
        $this->fase_pedido = $fase_pedido;

        return $this;
    }

    public function getTipoPedido(): ?TipoPedido
    {
        return $this->tipo_pedido;
    }

    public function setTipoPedido(?TipoPedido $tipo_pedido): self
    {
        $this->tipo_pedido = $tipo_pedido;

        return $this;
    }

    public function getUpdateAt(): ?\DateTimeImmutable
    {
        return $this->updateAt;
    }

    public function setUpdateAt(\DateTimeImmutable $updateAt): self
    {
        $this->updateAt = $updateAt;

        return $this;
    }

    public function isIsAtivo(): ?bool
    {
        return $this->isAtivo;
    }

    public function setIsAtivo(bool $isAtivo): self
    {
        $this->isAtivo = $isAtivo;

        return $this;
    }

    /**
     * @return Collection<int, TransferenciaPedido>
     */
    public function getTransferenciaPedidos(): Collection
    {
        return $this->transferenciaPedidos;
    }

    public function addTransferenciaPedido(TransferenciaPedido $transferenciaPedido): self
    {
        if (!$this->transferenciaPedidos->contains($transferenciaPedido)) {
            $this->transferenciaPedidos->add($transferenciaPedido);
            $transferenciaPedido->setPedido($this);
        }

        return $this;
    }

    public function removeTransferenciaPedido(TransferenciaPedido $transferenciaPedido): self
    {
        if ($this->transferenciaPedidos->removeElement($transferenciaPedido)) {
            // set the owning side to null (unless already changed)
            if ($transferenciaPedido->getPedido() === $this) {
                $transferenciaPedido->setPedido(null);
            }
        }

        return $this;
    }

    public function getUsuario(): ?User
    {
        return $this->usuario;
    }

    public function setUsuario(?User $usuario): self
    {
        $this->usuario = $usuario;

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->createdAt;
    }

    public function setCreatedAt(\DateTimeImmutable $createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function isTranferido(): ?bool
    {
        return $this->tranferido;
    }

    public function setTranferido(?bool $tranferido): self
    {
        $this->tranferido = $tranferido;

        return $this;
    }

    /**
     * @return Collection<int, EstadoFinalPedido>
     */
    public function getEstadoFinalPedidos(): Collection
    {
        return $this->estadoFinalPedidos;
    }

    public function addEstadoFinalPedido(EstadoFinalPedido $estadoFinalPedido): self
    {
        if (!$this->estadoFinalPedidos->contains($estadoFinalPedido)) {
            $this->estadoFinalPedidos->add($estadoFinalPedido);
            $estadoFinalPedido->setPedido($this);
        }

        return $this;
    }

    public function removeEstadoFinalPedido(EstadoFinalPedido $estadoFinalPedido): self
    {
        if ($this->estadoFinalPedidos->removeElement($estadoFinalPedido)) {
            // set the owning side to null (unless already changed)
            if ($estadoFinalPedido->getPedido() === $this) {
                $estadoFinalPedido->setPedido(null);
            }
        }

        return $this;
    }

    public function getObservacao(): ?string
    {
        return $this->observacao;
    }

    public function setObservacao(?string $observacao): self
    {
        $this->observacao = $observacao;

        return $this;
    }
}
