<?php

namespace App\Entity;

use App\Repository\MunicipioRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: MunicipioRepository::class)]
class Municipio
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $nome = null;

    #[ORM\Column]
    private ?bool $ativo_is = null;

    #[ORM\OneToMany(mappedBy: 'municipio', targetEntity: Comuna::class)]
    private Collection $comunas;

    #[ORM\ManyToOne(inversedBy: 'municipios')]
    private ?Provincia $provincia = null;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $updateAt = null;

    public function __construct()
    {
        $this->ativo_is = true;
        $this->comunas = new ArrayCollection();
        $this->updateAt = new \DateTimeImmutable();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNome(): ?string
    {
        return $this->nome;
    }

    public function setNome(string $nome): self
    {
        $this->nome = $nome;

        return $this;
    }


    public function isAtivoIs(): ?bool
    {
        return $this->ativo_is;
    }

    public function setAtivoIs(bool $ativo_is): self
    {
        $this->ativo_is = $ativo_is;

        return $this;
    }

    /**
     * @return Collection<int, Comuna>
     */
    public function getComunas(): Collection
    {
        return $this->comunas;
    }

    public function addComuna(Comuna $comuna): self
    {
        if (!$this->comunas->contains($comuna)) {
            $this->comunas->add($comuna);
            $comuna->setMunicipio($this);
        }

        return $this;
    }

    public function removeComuna(Comuna $comuna): self
    {
        if ($this->comunas->removeElement($comuna)) {
            // set the owning side to null (unless already changed)
            if ($comuna->getMunicipio() === $this) {
                $comuna->setMunicipio(null);
            }
        }

        return $this;
    }

    public function getProvincia(): ?Provincia
    {
        return $this->provincia;
    }

    public function setProvincia(?Provincia $provincia): self
    {
        $this->provincia = $provincia;

        return $this;
    }

    public function getUpdateAt(): ?\DateTimeImmutable
    {
        return $this->updateAt;
    }

    public function setUpdateAt(?\DateTimeImmutable $updateAt): self
    {
        $this->updateAt = $updateAt;

        return $this;
    }
}
