<?php

namespace App\Entity;

use App\Repository\EstadoFinalPedidoRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: EstadoFinalPedidoRepository::class)]
class EstadoFinalPedido
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column]
    private ?\DateTimeImmutable $createdAt = null;

    #[ORM\Column]
    private ?\DateTimeImmutable $updateAt = null;

    #[ORM\Column(type: Types::ARRAY, nullable: true)]
    private array $estadoPedido = [];

    #[ORM\Column]
    private ?bool $isAtivo = null;

    #[ORM\ManyToOne(inversedBy: 'estadoFinalPedidos')]
    private ?TransferenciaPedido $pedidoTransferido = null;

    #[ORM\Column(nullable: true)]
    private ?bool $isAtendido = null;

    #[ORM\Column(type: Types::TEXT, nullable: true)]
    private ?string $observacao = null;

    public function __construct()
    {
        $this->createdAt = new \DateTimeImmutable();
        $this->updateAt = new \DateTimeImmutable();
        $this->isAtivo = true;
        $this->isAtendido = false;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->createdAt;
    }

    public function setCreatedAt(\DateTimeImmutable $createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdateAt(): ?\DateTimeImmutable
    {
        return $this->updateAt;
    }

    public function setUpdateAt(\DateTimeImmutable $updateAt): self
    {
        $this->updateAt = $updateAt;

        return $this;
    }

    public function getEstadoPedido(): array
    {
        return $this->estadoPedido;
    }

    public function setEstadoPedido(?array $estadoPedido): self
    {
        $this->estadoPedido = $estadoPedido;

        return $this;
    }

    public function isIsAtivo(): ?bool
    {
        return $this->isAtivo;
    }

    public function setIsAtivo(bool $isAtivo): self
    {
        $this->isAtivo = $isAtivo;

        return $this;
    }

    public function getPedidoTransferido(): ?TransferenciaPedido
    {
        return $this->pedidoTransferido;
    }

    public function setPedidoTransferido(?TransferenciaPedido $pedidoTransferido): self
    {
        $this->pedidoTransferido = $pedidoTransferido;

        return $this;
    }

    public function isIsAtendido(): ?bool
    {
        return $this->isAtendido;
    }

    public function setIsAtendido(?bool $isAtendido): self
    {
        $this->isAtendido = $isAtendido;

        return $this;
    }

    public function getObservacao(): ?string
    {
        return $this->observacao;
    }

    public function setObservacao(?string $observacao): self
    {
        $this->observacao = $observacao;

        return $this;
    }
}
