<?php

namespace App\Entity;

use function App\Controller\request;
use App\Repository\DepartamentoRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: DepartamentoRepository::class)]
class Departamento
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 90)]
    private ?string $nome = null;

    #[ORM\OneToMany(mappedBy: 'departamento', targetEntity: User::class)]
    private Collection $users;

    #[ORM\OneToMany(mappedBy: 'departamento', targetEntity: TransferenciaPedido::class)]
    private Collection $transferenciaPedidos;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $createdAt = null;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $updateAt = null;

    #[ORM\Column(nullable: true)]
    private ?bool $isAtivo = null;

    #[ORM\OneToMany(mappedBy: 'departamento', targetEntity: User::class, cascade: ['persist'])]
    private Collection $usuarios;


    public function __construct()
    {
        $this->createdAt = new \DateTimeImmutable();
        $this->updateAt = new \DateTimeImmutable();
        //$this->users = new ArrayCollection();
        $this->transferenciaPedidos = new ArrayCollection();
        $this->isAtivo = true;
        $this->usuarios = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNome(): ?string
    {
        return $this->nome;
    }

    public function setNome(string $nome): self
    {
        $this->nome = $nome;

        return $this;
    }

    /**
     * @return Collection<int, User>
     */
    public function getUsers(): Collection
    {
        return $this->users;
    }

    public function addUser(User $user): self
    {
        if (!$this->users->contains($user)) {
            $this->users->add($user);
            $user->setDepartamento($this);
        }

        return $this;
    }

    public function removeUser(User $user): self
    {
        if ($this->users->removeElement($user)) {
            // set the owning side to null (unless already changed)
            if ($user->getDepartamento() === $this) {
                $user->setDepartamento(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, TransferenciaPedido>
     */
    public function getTransferenciaPedidos(): Collection
    {
        return $this->transferenciaPedidos;
    }

    public function addTransferenciaPedido(TransferenciaPedido $transferenciaPedido): self
    {
        if (!$this->transferenciaPedidos->contains($transferenciaPedido)) {
            $this->transferenciaPedidos->add($transferenciaPedido);
            $transferenciaPedido->setDepartamento($this);
        }

        return $this;
    }

    public function removeTransferenciaPedido(TransferenciaPedido $transferenciaPedido): self
    {
        if ($this->transferenciaPedidos->removeElement($transferenciaPedido)) {
            // set the owning side to null (unless already changed)
            if ($transferenciaPedido->getDepartamento() === $this) {
                $transferenciaPedido->setDepartamento(null);
            }
        }

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->createdAt;
    }

    public function setCreatedAt(?\DateTimeImmutable $createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdateAt(): ?\DateTimeImmutable
    {
        return $this->updateAt;
    }

    public function setUpdateAt(?\DateTimeImmutable $updateAt): self
    {
        $this->updateAt = $updateAt;

        return $this;
    }

    public function isIsAtivo(): ?bool
    {
        return $this->isAtivo;
    }

    public function setIsAtivo(?bool $isAtivo): self
    {
        $this->isAtivo = $isAtivo;

        return $this;
    }

    /**
     * @return Collection<int, User>
     */
    public function getUsuarios(): Collection
    {
        return $this->usuarios;
    }

    public function addUsuario(User $usuario): self
    {
        if (!$this->usuarios->contains($usuario)) {
            $this->usuarios->add($usuario);
            $usuario->setDepartamento($this);
        }

        return $this;
    }

    public function removeUsuario(User $usuario): self
    {
        if ($this->usuarios->removeElement($usuario)) {
            // set the owning side to null (unless already changed)
            if ($usuario->getDepartamento() === $this) {
                $usuario->setDepartamento(null);
            }
        }

        return $this;
    }

    public function __toString()
    {
        return "".$this->nome;
    }

}
