<?php

namespace App\Entity;

use App\Repository\ComunaRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: ComunaRepository::class)]
class Comuna
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    private ?string $nome = null;

    #[ORM\Column]
    private ?\DateTimeImmutable $updateAte = null;

    #[ORM\Column]
    private ?bool $isAtivo = null;

    #[ORM\ManyToOne(inversedBy: 'comunas')]
    private ?Municipio $municipio = null;

    #[ORM\OneToMany(mappedBy: 'comuna', targetEntity: Bairro::class)]
    private Collection $bairros;


    public function __construct()
    {
        $this->updateAte = new \DateTimeImmutable();
        $this->isAtivo = true;
        //$this->bairros = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNome(): ?string
    {
        return $this->nome;
    }

    public function setNome(string $nome): self
    {
        $this->nome = $nome;

        return $this;
    }

    public function getUpdateAte(): ?\DateTimeImmutable
    {
        return $this->updateAte;
    }

    public function setUpdateAte(\DateTimeImmutable $updateAte): self
    {
        $this->updateAte = $updateAte;

        return $this;
    }

    public function isIsAtivo(): ?bool
    {
        return $this->isAtivo;
    }

    public function setIsAtivo(bool $isAtivo): self
    {
        $this->isAtivo = $isAtivo;

        return $this;
    }

    public function getMunicipio(): ?Municipio
    {
        return $this->municipio;
    }

    public function setMunicipio(?Municipio $municipio): self
    {
        $this->municipio = $municipio;

        return $this;
    }

    /**
     * @return Collection<int, Bairro>
     */
    public function getBairros(): Collection
    {
        return $this->bairros;
    }

    public function addBairro(Bairro $bairro): self
    {
        if (!$this->bairros->contains($bairro)) {
            $this->bairros->add($bairro);
            $bairro->setComuna($this);
        }

        return $this;
    }

    public function removeBairro(Bairro $bairro): self
    {
        if ($this->bairros->removeElement($bairro)) {
            // set the owning side to null (unless already changed)
            if ($bairro->getComuna() === $this) {
                $bairro->setComuna(null);
            }
        }

        return $this;
    }



}
