<?php

namespace App\Controller;

use App\Entity\Pedido;
use App\Entity\TransferenciaPedido;
use App\Form\TransferenciaPedidoType;
use App\Repository\EstadoPedidoRepository;
use App\Repository\FasePedidoRepository;
use App\Repository\TransferenciaPedidoRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/transferencia/pedido', name: 'app_transferencia_pedido_')]
class TransferenciaPedidoController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(TransferenciaPedidoRepository $transferenciaPedidoRepository,Request $request, PaginatorInterface $paginator): Response
    {
        $user = $this->getUser();
        $provincia = $user->getBairro()->getComuna()->getMunicipio()->getProvincia();
        $query = $transferenciaPedidoRepository->findAlltransferenciaProvincia($provincia);
        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),1);
        return $this->render('transferencia_pedido/index.html.twig', compact('pagination'));

    }

    #[Route('/enviar/{id}', name: 'enviar')]
    public function transferir(Pedido $pedido,Request $request, EntityManagerInterface $em,
                               FasePedidoRepository $fasePedidoRepository, EstadoPedidoRepository $estadoPedidoRepository){

        $fase = $fasePedidoRepository->findOneByNome("Segunda Fase");
        $estado = $estadoPedidoRepository->findOneByNome('Processo em Analise');
        $tranferir = new TransferenciaPedido();
        $form = $this->createForm(TransferenciaPedidoType::class, $tranferir);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){

           $pedido->setFasePedido($fase);
           $pedido->setEstadoPedido($estado);
           $pedido->setTranferido(true);
           $pedido->setUpdateAt(new \DateTimeImmutable());
           $tranferir->setPedido($pedido);
           $em->persist($tranferir);
           $em->flush();
           $this->addFlash('success','Pedido transferido com sucesso!');
           return $this->redirectToRoute('app_transferencia_pedido_index');
        }

        return $this->render('transferencia_pedido/transferir.html.twig',[
            'form' => $form->createView()
        ]);
    }
}
