<?php

namespace App\Controller;

use App\Entity\TipoPedido;
use App\Form\TipoPedidoType;
use App\Repository\TipoPedidoRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/tipo/pedido', name: 'app_tipo_pedido_')]
class TipoPedidoController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(Request $request, TipoPedidoRepository $tipoPedidoRepository, PaginatorInterface $paginator): Response
    {
        $query = $tipoPedidoRepository->findAllTipoPedidos();
        $pagination = $paginator->paginate($query, $request->query->getInt('page',1),3);
        return $this->render('tipo_pedido/index.html.twig', compact('pagination'));
    }

    #[Route('/add', name: 'add')]
    public function add(Request $request, EntityManagerInterface $em): Response
    {
        $tipo = new TipoPedido();
        $form = $this->createForm(TipoPedidoType::class,$tipo);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($tipo);
            $em->flush();

            $this->addFlash('success','Tipo de pedido guardado com sucesso!');
            return $this->redirectToRoute('app_tipo_pedido_add');
        }
        return $this->render('tipo_pedido/addTipopedido.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
