<?php

namespace App\Controller;

use App\Entity\Sexo;
use App\Form\SexoType;
use App\Repository\SexoRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/sexo', name: 'app_sexo_')]
class SexoController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(SexoRepository $sexoRepository): Response
    {
        $sexos = $sexoRepository->findAll();
        return $this->render('sexo/index.html.twig', compact('sexos'));
    }

    #[Route('/add', name: 'add')]
    public function addSexo(Request $request, EntityManagerInterface $em): Response
    {
        $sexo = new Sexo();
        $form = $this->createForm(SexoType::class,$sexo);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($sexo);
            $em->flush();
            $this->addFlash('success','Genero salvo com sucesso!');
            return $this->redirectToRoute('app_sexo_add');
        }
        return $this->render('sexo/addSexo.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
