<?php

namespace App\Controller;

use App\Entity\Provincia;
use App\Form\ProvinciaType;
use App\Repository\ProvinciaRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/provincia', name: 'app_provincia_')]
class ProvinciaController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(Request $request,ProvinciaRepository $provinciaRepository, PaginatorInterface $paginator): Response
    {
        $query = $provinciaRepository->findAllProvincias();

        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),6 );

        return $this->render('provincia/index.html.twig', compact('pagination'));
    }

    #[Route('/add', name: 'add')]
    public function addProvincia(Request $request, EntityManagerInterface $em): Response
    {
        $provincia = new Provincia();
        $form = $this->createForm(ProvinciaType::class,$provincia);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($provincia);
            $em->flush();
            $this->addFlash('success', 'Provincia guardado com sucesso .');
            return $this->redirectToRoute('app_provincia_add');
        }
        return $this->render('provincia/addProvincia.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
