<?php

namespace App\Controller;

use App\Entity\EstadoFinalPedido;
use App\Entity\Pedido;
use App\Entity\TransferenciaPedido;
use App\Form\EstadoFinalPedidoType;
use App\Repository\EstadoPedidoRepository;
use App\Repository\FasePedidoRepository;
use App\Repository\PedidoDepartamentoRepository;
use App\Repository\TransferenciaPedidoRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/pedidos/departamento', name: 'app_pedidos_departamento_')]
class PedidosDepartamentoController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(TransferenciaPedidoRepository $repository, Request $request,PaginatorInterface $paginator): Response
    {
        $user = $this->getUser();
        $provincia = $user->getBairro()->getComuna()->getMunicipio()->getProvincia();
        $departamento = $user->getDepartamento();

        $query = $repository->findByAllTransferenciaDepartamento($departamento,$provincia);

        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),1);
        return $this->render('pedidos_departamento/index.html.twig', compact('pagination'));
    }


    #[Route('/atendimento/{id}', name: 'atender')]
    public function atendimento(TransferenciaPedido $transferenciaPedido,Request $request, EntityManagerInterface $em,
                               FasePedidoRepository $fasePedidoRepository, EstadoPedidoRepository $estadoPedidoRepository){

        $fase = $fasePedidoRepository->findOneByNome("Terceira Fase");
        $estadofinal = new EstadoFinalPedido();
        $form = $this->createForm(EstadoFinalPedidoType::class, $estadofinal);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $estad = $form->get('estadoPedido')->getData();
            $estado = $estadoPedidoRepository->findOneByNome($estad);
            $transferenciaPedido->getPedido()->setFasePedido($fase);
            $transferenciaPedido->getPedido()->setUpdateAt(new \DateTimeImmutable());
            $transferenciaPedido->getPedido()->setEstadoPedido($estado);
            $transferenciaPedido->getPedido()->setObservacao($estadofinal->getObservacao());
            //$pedido->setTranferido(true);
            $transferenciaPedido->setUpdateAt(new \DateTimeImmutable());
            $estadofinal->setPedidoTransferido($transferenciaPedido);
            $estadofinal->setIsAtendido(true);
            $em->persist($estadofinal);
            $em->flush();
            $this->addFlash('success','Pedido atendido com sucesso!');
            return $this->redirectToRoute('app_pedidos_departamento_index');
        }

        return $this->render('pedidos_departamento/atendimento.html.twig',[
            'form' => $form->createView()
        ]);
    }


}
