<?php

namespace App\Controller;

use App\Entity\EstadoPedido;
use App\Entity\Pedido;
use App\Form\PedidoType;
use App\Repository\EstadoFinalPedidoRepository;
use App\Repository\EstadoPedidoRepository;
use App\Repository\FasePedidoRepository;
use App\Repository\PedidoRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/pedido', name: 'app_pedido_')]
class PedidoController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(PedidoRepository $pedidoRepository,Request $request, PaginatorInterface $paginator): Response
    {
        $user = $this->getUser();
        $query = $pedidoRepository->findByPedidoUser($user);
        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),1);
        return $this->render('pedido/index.html.twig', compact('pagination'));
    }

    #[Route('/provincial', name: 'lista')]
    public function listaPorProvincia(PedidoRepository $pedidoRepository,Request $request, PaginatorInterface $paginator): Response
    {
        $user = $this->getUser();
        $provincia = $user->getBairro()->getComuna()->getMunicipio()->getProvincia();
        $query = $pedidoRepository->findByAllPedidoProvincia($provincia);
        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),1);
        return $this->render('pedido/listapedidosProvincial.html.twig', compact('pagination'));
    }

    #[Route('/add', name: 'add')]
    public function addPedido(Request $request, EntityManagerInterface $em,
                              EstadoPedidoRepository $estadoPedidoRepository,
                              FasePedidoRepository $fasePedidoRepository): Response
    {
        $pedido = new Pedido();
        $form = $this->createForm(PedidoType::class,$pedido);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){

            $user = $this->getUser();
            $pedido->setUsuario($user);

            $estado = $estadoPedidoRepository->findOneByNome("Processo Pendente");
            $fase = $fasePedidoRepository->findOneByNome("Primeira Fase");
            $pedido->setFasePedido($fase);
            $pedido->setEstadoPedido($estado);
            $em->persist($pedido);
            $em->flush();
            $this->addFlash('success', 'Requisição enviada com sucesso!');
            return $this->redirectToRoute('app_pedido_add');
        }
        return $this->render('pedido/addPedido.html.twig', [
            'form' => $form->createView(),
        ]);
    }


}
