<?php

namespace App\Controller;

use App\Entity\Municipio;
use App\Form\MunicipioType;
use App\Repository\MunicipioRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/municipio', name: 'app_municipio_')]
class MunicipioController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(Request $request,MunicipioRepository $municipioRepository, PaginatorInterface $paginator): Response
    {
        $query =  $municipioRepository->findAllMunicipios();

        $pagination = $paginator->paginate($query, $request->query->getInt('page',1),6);
        return $this->render('municipio/index.html.twig', compact('pagination'));
    }

    #[Route('/add', name: 'add')]
    public function addMunicipio(Request $request, EntityManagerInterface $em): Response
    {
        $municipio = new Municipio();
        $form = $this->createForm(MunicipioType::class,$municipio);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($municipio);
            $em->flush();
            $this->addFlash('success', 'Município guardado com sucesso .');
            return $this->redirectToRoute('app_municipio_add');
        }
        return $this->render('municipio/addMunicipio.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
