<?php

namespace App\Controller;

use App\Entity\Pedido;
use App\Repository\EstadoFinalPedidoRepository;
use Dompdf\Dompdf;
use Endroid\QrCode\Builder\BuilderInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/relatorio/pdf', name: 'app_imprimir_relatorio_')]
class GerarRelatorioPdfController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(): Response
    {
        return $this->render('gerar_relatorio_pdf/index.html.twig', [
            'controller_name' => 'GerarRelatorioPdfController',
        ]);
    }

    #[Route('/imprimir/{id}', name: 'pdf')]
    public function gerarPdf(Pedido $pedido, EstadoFinalPedidoRepository $estadoFinalPedidoRepository, BuilderInterface $builder): Response
    {
        // return $this->render('pdf_generator/index.html.twig', [
        //     'controller_name' => 'PdfGeneratorController',
        // ]);
        //$data = [
        //'imageSrc'  => $this->imageToBase64($this->getParameter('kernel.project_dir') . '/public/img/profile.png'),
        //    'name'         => 'John Doe',
        //    'quantidade'      => 'USA',
        //    'tempoVida' => '000000000',
        //    'taxaAmortizacao'        => 'john.doe@email.com',
        //    'dataAquisicao'        => 'john.doe@email.com'
        //];

        $qrcode = $builder->size(400)
            ->margin(20)
            ->data('Serviço de Proteção Civil e Bombeiros')->build();

        $imgQR = $qrcode->getDataUri();
        $estadofinal = $estadoFinalPedidoRepository->findByAllEstadoFinalPedido($pedido);

        $logo1  = $this->imageToBase64($this->getParameter('kernel.project_dir') . '/public/img/logo1.jpg');
        $logo2  = $this->imageToBase64($this->getParameter('kernel.project_dir') . '/public/img/logo2.jpg');
        $logo3  = $this->imageToBase64($this->getParameter('kernel.project_dir') . '/public/img/logo3.jpg');

        //$imageSrc  = $this->imageToBase64($this->getParameter('kernel.project_dir') . '/public/img/abai.png');
        $html =  $this->renderView('gerar_relatorio_pdf/gerarPedf.html.twig', compact('estadofinal','logo1','logo2','logo3','imgQR'));
        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);

        $dompdf->render();

        return new Response (
            $dompdf->stream('resume', ["Attachment" => false]),
            Response::HTTP_OK,
            ['Content-Type' => 'application/pdf']
        );
    }

    private function imageToBase64($path) {
        $path = $path;
        $type = pathinfo($path, PATHINFO_EXTENSION);
        $data = file_get_contents($path);
        $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
        return $base64;
    }
}
