<?php

namespace App\Controller;

use App\Entity\FasePedido;
use App\Form\FasePedidoType;
use App\Repository\FasePedidoRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/fase/pedido', name: 'app_fase_pedido_')]
class FasePedidoController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(Request $request, FasePedidoRepository $fasePedidoRepository, PaginatorInterface $paginator): Response
    {
        $query = $fasePedidoRepository->findAllFasePedidos();
        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),3);
        return $this->render('fase_pedido/index.html.twig', compact('pagination'));
    }

    #[Route('/add', name: 'add')]
    public function add(Request $request, EntityManagerInterface $em): Response
    {
        $fase = new FasePedido();
        $form = $this->createForm(FasePedidoType::class,$fase);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($fase);
            $em->flush();

            $this->addFlash('success','Fase de pedido guardado com sucesso!');
            return $this->redirectToRoute('app_fase_pedido_add');
        }
        return $this->render('fase_pedido/addFasepedido.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
