<?php

namespace App\Controller;

use App\Entity\Extintor;
use App\Form\ExtintorType;
use App\Repository\ExtintorRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use function Symfony\Component\HttpFoundation\getUser;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/extintor', name: 'app_extintor_')]
class ExtintorController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(ExtintorRepository $extintorRepository): Response
    {
        $requisicoes = $extintorRepository->findAll();
        return $this->render('extintor/listarequisicao.html.twig', compact('requisicoes'));
    }

    #[Route('/requisicao', name: 'requisicao')]
    public function requisicao(Request $request, EntityManagerInterface $em): Response
    {
        $extintor = new Extintor();
        $form = $this->createForm(ExtintorType::class,$extintor);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){

            $user = $this->getUser();
            $extintor->setUsuario($user);

            $em->persist($extintor);
            $em->flush();
            $this->addFlash('success','Requisição de extintor enviada com sucesso!');

            return $this->redirectToRoute('app_admin_index');
        }

        return $this->render('extintor/extintor-index.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
