<?php

namespace App\Controller;

use App\Entity\EstadoPedido;
use App\Form\EstadoPedidoType;
use App\Repository\EstadoPedidoRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/estado/pedido', name: 'app_estado_pedido_')]
class EstadoPedidoController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(Request $request,EstadoPedidoRepository $estadoPedidoRepository, PaginatorInterface $paginator): Response
    {
        $query = $estadoPedidoRepository->findAllEstados();

        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),3);

        return $this->render('estado_pedido/index.html.twig', compact('pagination'));
    }

    #[Route('/add', name: 'add')]
    public function add(Request $request, EntityManagerInterface $em): Response
    {
        $estado = new EstadoPedido();
        $form = $this->createForm(EstadoPedidoType::class,$estado);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($estado);
            $em->flush();
            $this->addFlash('success','Estado de pedido guardado com sucesso!');
            return $this->redirectToRoute('app_estado_pedido_add');
        }
        return $this->render('estado_pedido/addEstadopedido.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
