<?php

namespace App\Controller;

use App\Entity\Departamento;
use App\Form\DepartamentoType;
use App\Repository\DepartamentoRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/departamento', name: 'app_departamento_')]
class DepartamentoController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(DepartamentoRepository $departamentoRepository): Response
    {
        $departamentos = $departamentoRepository->findAll();
        return $this->render('departamento/index.html.twig', compact('departamentos'));
    }

    #[Route('/add', name: 'add')]
    public function add(Request $request, EntityManagerInterface $em): Response
    {
        $departamento = new Departamento();
        $form = $this->createForm(DepartamentoType::class,$departamento);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($departamento);
            $em->flush();

            $this->addFlash('success','Departamento guardado com sucesso!');
            return $this->redirectToRoute('app_departamento_add');
        }
        return $this->render('departamento/addDepartamento.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
