<?php

namespace App\Controller;

use App\Entity\Documentos;
use App\Entity\Extintor;
use App\Entity\User;
use App\Form\ExtintorType;
use App\Form\UsuarioFormType;
use App\Repository\ExtintorRepository;
use App\Service\PictureService;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use function Symfony\Bundle\FrameworkBundle\Controller\isGranted;
use function Symfony\Bundle\FrameworkBundle\Controller\redirectToRoute;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use function Symfony\Component\String\match;
use Symfony\Component\Security\Core\Security;

#[Route('/admin', name: 'app_admin_')]
class AdminController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(): Response
    {
        $this->denyAccessUnlessGranted("IS_AUTHENTICATED_FULLY");

        /** @var User $user */
        $user = $this->getUser();
        return match ($user->isVerified() && $this->isGranted('ROLE_CLIENTE_ADMIN')){
            true => $this->render('admin/index.html.twig'),
            false => $this->render('admin/please-verify-email.html.twig'),
        };



        /*
           return match ($user->isVerified() && $this->isGranted('ROLE_SECRE_ADMIN')){
            true => $this->render('admin/secretaria/index.html.twig'),
            false => $this->render('admin/please-verify-email.html.twig'),
        };

        return match ($user->isVerified() && $this->isGranted('ROLE_ADMIN')){
        true => $this->render('admin/principal/index.html.twig'),
            false => $this->render('admin/please-verify-email.html.twig'),
        };
        if($user->isVerified() && $this->isGranted('ROLE_CLIENTE_ADMIN')){
            return $this->render('admin/index.html.twig');
        }
        if($user->isVerified() && $this->isGranted('ROLE_SECRE_ADMIN')){
             return $this->render('admin/secretaria/index.html.twig');
        }

        if($user->isVerified() && $this->isGranted('ROLE_ADMIN')){
             return $this->render('admin/principal/index.html.twig');
        }

        return $this->render('admin/please-verify-email.html.twig');
        */
    }

    #[Route('/usuario/editar/{id}', name: 'user_edit')]
    public function editaruser(User $user, Request $request,EntityManagerInterface $em, PictureService $pictureService){

        $this->denyAccessUnlessGranted('USER_EDIT',$user);
        $form = $this->createForm(UsuarioFormType::class,$user);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){

            /*$documentos = $form->get('documentos')->getData();

            //dd($documentos);
            foreach ($documentos as $documento){
                $folder = 'doc';
                $fichier = $pictureService->add($documento,$folder,300,300);

                $img = new Documentos();
                $img->setNome($fichier);
                $user->addDocumento($img);
            }*/
            $em->persist($user);
            $em->flush();
            $this->addFlash('success','Usuário editado com sucesso.');

            return $this->redirectToRoute('app_admin_index');
        }
        if($this->isGranted('ROLE_ADMIN')){
            return $this->render('admin/usuario/edituser1.html.twig',[
                'form' => $form->createView(),
                'user' => $user
            ]);
        }

        if($this->isGranted('ROLE_SECRE_ADMIN')){
            return $this->render('admin/usuario/edituser2.html.twig',[
                'form' => $form->createView(),
                'user' => $user
            ]);
        }

        if($this->isGranted('ROLE_CLIENTE_ADMIN')){
            return $this->render('admin/usuario/edituser3.html.twig',[
                'form' => $form->createView(),
                'user' => $user
            ]);
        }


    }

    #[Route('/imagem/{id}', name: 'apagar_imagem', methods: ['DELETE'])]
    public function apagarImagem(Documentos $documentos,
                                 Request $request, EntityManagerInterface $em,
                                 PictureService $pictureService): JsonResponse{

        $data = json_decode($request->getContent(),true);

        if($this->isCsrfTokenValid('delete' . $documentos->getId(),$data['_token'])){
            $nom = $documentos->getNome();

            if($pictureService->delete($nom,'doc',300,300)){
                $em->remove($documentos);
                $em->flush();
                return new JsonResponse(['success' => true],200);
            }
            return new JsonResponse(['error' => 'Erro de supressão'],400);
        }
        return new JsonResponse(['error' => 'Token invalido'],400);

    }

    #[Route('/extintores', name: 'extintor')]
    public function listarExtintor(ExtintorRepository $extintorRepository): Response
    {
        $requisicoes = $extintorRepository->findBy([],['datarequisicaoAt'=>'ASC']);
        return $this->render('admin/listarequisicao.html.twig', compact('requisicoes'));
    }

    #[Route('/requisicao', name: 'requisicao')]
    public function requisicao(Request $request, EntityManagerInterface $em): Response
    {
        $extintor = new Extintor();
        $form = $this->createForm(ExtintorType::class,$extintor);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){

            $user = $this->getUser();
            $extintor->setUsuario($user);

            $em->persist($extintor);
            $em->flush();
            $this->addFlash('success','Requisição de extintor enviada com sucesso!');

            return $this->redirectToRoute('app_admin_index');
        }

        return $this->render('admin/extintor-index.html.twig', [
            'form' => $form->createView(),
        ]);
    }

}
