<?php

namespace App\Controller\Admin;

use App\Entity\AdminUpdateExtintor;
use App\Entity\Extintor;
use App\Entity\RequisicaoExtintor;
use App\Form\MudarEstadoExtintorType;
use App\Repository\AdminUpdateExtintorRepository;
use App\Repository\ExtintorRepository;
use App\Repository\RequisicaoExtintorRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/requisicao/extintor', name: 'app_admin_requisicao_extintor_')]
class RequisicaoExtintorController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(): Response
    {
        return $this->render('admin/requisicao_extintor/index.html.twig', [
            'controller_name' => 'RequisicaoExtintorController',
        ]);
    }

    #[Route('/lista', name: 'lista')]
    public function listarRequisicaoExtintor(AdminUpdateExtintorRepository $extintorRepository){

        $requisicao = $extintorRepository->findAll();
        return $this->render('admin/requisicao_extintor/listarequisicaoExtintor.html.twig', compact('requisicao'));
    }


    #[Route('/lista/entrada', name: 'extintor_requisicao')]
    public function listaExtintorRequisicao(ExtintorRepository $extintorRepository,
                                            PaginatorInterface $paginator,Request $request){

        $requisicao = $extintorRepository->findExtintorAll();

        $pagination = $paginator->paginate(
            $requisicao,
            $request->query->getInt('page',1),1
        );
        return $this->render('admin/requisicao_extintor/listaEstintorNotChanged.html.twig', compact('requisicao','pagination'));
    }

    #[Route('/mudarestado/{id}', name: 'mudar')]
    public function changeStatus(Extintor $extintor, Request $request, EntityManagerInterface $em,MailerInterface $mailer){

        $form = $this->createForm(MudarEstadoExtintorType::class,$extintor);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){

            $extintor->setDataUpdating(new \DateTimeImmutable('now'));
            $adminextintor = new AdminUpdateExtintor();

            //$adminextintor->setUpdatedataAt(new \DateTimeImmutable());

            $adminextintor->setUsuarioadmin($this->getUser());

            $adminextintor->setExtintorUpdating($extintor);
            $em->persist($adminextintor);
            $em->flush();

            try{
                $email =(new TemplatedEmail())
                    ->from(new Address('bemvindo@responserv.ao', 'Notificação do estado do processo de requisição'))
                    ->to($extintor->getUsuario()->getEmail())
                    ->subject('Estado da requisição')
                    ->htmlTemplate('emails/mail.html')
                    ->context([
                        'nome'=>$extintor->getUsuario()->getNome(),
                        'estado' =>$extintor->getEstado()
                    ]);
                $mailer->send($email);
                return new Response("Email enviado corretamente..");
            }catch(\Throwable $throwable){
                return new Response($throwable->getMessage());
            }
            $this->addFlash('success','Estado da requisição alterado com sucesso.');

            return $this->redirectToRoute('app_admin_requisicao_extintor_extintor_requisicao');
        }
        return $this->render('admin/requisicao_extintor/editarRequisicao.html.twig',[
            'form' => $form->createView(),
        ]);

    }


    #[Route('/delete/lastupdate/{id}', name: 'delete_last')]
    public function deleteLastupdate(AdminUpdateExtintor $adminUpdateExtintor, EntityManagerInterface $em){
        $em->remove($adminUpdateExtintor);
           $em->flush();
           $this->addFlash('success','Estado da requisição alterado com sucesso.');
           return $this->redirectToRoute('app_admin_requisicao_extintor_lista');
    }



}
