<?php

namespace App\Controller\Admin;

use App\Entity\Documentos;
use App\Entity\User;
use App\Form\RoleUsuarioType;
use App\Form\UsuarioFormType;
use App\Repository\UserRepository;
use App\Service\PictureService;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/principal', name: 'app_admin_principal_')]
class PrincipalController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(): Response
    {
        return $this->render('admin/principal/index.html.twig', [
            'controller_name' => 'PrincipalController',
        ]);
    }
    #[Route('/listausuarios', name: 'usuarios')]
    public function listarusuarios(Request $request,UserRepository $userRepository, PaginatorInterface $paginator){

        $query = $userRepository->findAllUsers();

        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),4);
        return $this->render('admin/principal/allusers.html.twig',compact('pagination'));
    }

    #[Route('/usuario/editar/{id}', name: 'user_edit')]
    public function editaruser(User $user, Request $request,EntityManagerInterface $em){

        $this->denyAccessUnlessGranted('USER_EDIT',$user);
        $form = $this->createForm(RoleUsuarioType::class,$user);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){

            $em->persist($user);
            $em->flush();
            $this->addFlash('success','Papel do usuário editado com sucesso.');

            return $this->redirectToRoute('app_admin_principal_usuarios');
        }

        return $this->render('admin/usuario/index.html.twig',[
            'form' => $form->createView(),
            'user' => $user
        ]);
    }
    #[Route('/usuario/delete/{id}', name: 'delete')]
    public function delete(User $user): Response
    {
        $this->denyAccessUnlessGranted('USER_DELETE',$user);
        return $this->render('admin/usuario/index.html.twig', [
            'controller_name' => 'UserController',
        ]);
    }


}
