"use strict";

exports.__esModule = true;
exports.isJSONValue = isJSONValue;
exports.isJSONObject = isJSONObject;
exports.isJSONArray = isJSONArray;
exports.isString = isString;
exports.isNumber = isNumber;
exports.isBoolean = isBoolean;
exports.isNull = isNull;
exports.isUndefined = isUndefined;

function isJSONValue(value) {
  return value !== undefined;
}

function isJSONObject(value) {
  return typeof value === "object" && !isJSONArray(value) && !isNull(value);
}

function isJSONArray(value) {
  return Array.isArray(value);
}

function isString(value) {
  return typeof value === "string";
}

function isNumber(value) {
  return typeof value === "number";
}

function isBoolean(value) {
  return typeof value === "boolean";
}

function isNull(value) {
  return value === null;
}

function isUndefined(value) {
  return value === undefined;
}