export declare type JSONObject = {
    [key in string]?: JSONValue;
};
export declare type JSONValue = string | number | boolean | null | JSONObject | JSONArray;
export interface JSONArray extends Array<JSONValue> {
}
export declare function isJSONValue(value?: JSONValue): value is JSONValue;
export declare function isJSONObject(value?: JSONValue): value is JSONObject;
export declare function isJSONArray(value?: JSONValue): value is JSONArray;
export declare function isString(value?: JSONValue): value is string;
export declare function isNumber(value?: JSONValue): value is number;
export declare function isBoolean(value?: JSONValue): value is boolean;
export declare function isNull(value?: JSONValue): value is null;
export declare function isUndefined(value?: JSONValue): value is undefined;
