# tailwindcss-box-shadow

[![Version][npm-version-shield]][npm]
[![Build][github-ci-shield]][github-ci]
[![Downloads][npm-stats-shield]][npm-stats]
[![License][license-shield]][license]

A plugin that generates `shadow` utilities exactly as they are defined in the config - that is, without CSS variables.

## Installation

Install the plugin from npm:

```sh
# Using npm
npm install tailwindcss-box-shadow

# Using Yarn
yarn add tailwindcss-box-shadow
```

Then add the plugin to your `tailwind.config.js`:

```js
module.exports = {
  plugins: [
    require('tailwindcss-box-shadow'),
  ],
}
```

## Usage

Use the `shadow-{n}` utilities to add box shadows to elements:

```html
<div class="shadow-2xl">
  Box with big ass shadow
</div>
```

The plugin will generate the `box-shadow` utility exactly as defined in the Tailwind config, without `--tw-shadow-*` CSS variables:

```diff
- .shadow-xl {
-   --tw-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);
-   --tw-shadow-colored: 0 20px 25px -5px var(--tw-shadow-color), 0 8px 10px -6px var(--tw-shadow-color);
-   box-shadow: var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow);
- }
+ .shadow-xl {
+   box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1);
+ }
```

## Configuration

You may configure which utilities are generated by this plugin under the `boxShadow` key in your `tailwind.config.js` file:

```js
module.exports = {
  theme: {
    extend: {
      boxShadow: {
        button: '0 3px 9px 0 rgba(0, 0, 0, 0.09)',
      }
    }
  },
}
```

[npm]: https://www.npmjs.com/package/tailwindcss-box-shadow
[npm-stats]: https://npm-stat.com/charts.html?package=tailwindcss-box-shadow&from=2021-01-29
[npm-version-shield]: https://img.shields.io/npm/v/tailwindcss-box-shadow.svg
[npm-stats-shield]: https://img.shields.io/npm/dt/tailwindcss-box-shadow.svg?color=6875f5
[github-ci]: https://github.com/maizzle/tailwindcss-box-shadow/actions
[github-ci-shield]: https://github.com/maizzle/tailwindcss-box-shadow/actions/workflows/nodejs.yml/badge.svg
[license]: ./LICENSE
[license-shield]: https://img.shields.io/npm/l/tailwindcss-box-shadow.svg?style=color=0e9f6e
