"use strict";

exports.__esModule = true;
exports["default"] = parse;

var _typesJson = require("types-json");

exports.isJSONObject = _typesJson.isJSONObject;
exports.JSONObject = _typesJson.JSONObject;
exports.JSONValue = _typesJson.JSONValue;
exports.JSONArray = _typesJson.JSONArray;

function parse(text) {
  if (text) {
    try {
      var json = JSON.parse(text);

      if ((0, _typesJson.isJSONObject)(json)) {
        return json;
      } else {
        return undefined;
      }
    } catch (e) {
      return undefined;
    }
  } else {
    return undefined;
  }
}