"use strict";

exports.__esModule = true;
exports.readFile = readFile;
exports.readFileSync = readFileSync;

var _fs = _interopRequireWildcard(require("fs"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function getEncoding(buffer) {
  return buffer ? null : "utf8";
}

function readFile(_x) {
  return _readFile.apply(this, arguments);
}

function _readFile() {
  _readFile = _asyncToGenerator(function* (path) {
    for (var _len = arguments.length, _ref = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      _ref[_key - 1] = arguments[_key];
    }

    var _ref$ = _ref[0],
        options = _ref$ === void 0 ? {} : _ref$;
    return _fs.promises.readFile(path, {
      encoding: getEncoding(options.buffer)
    }).then(function (content) {
      return content;
    })["catch"](function () {
      return undefined;
    });
  });
  return _readFile.apply(this, arguments);
}

function readFileSync(path) {
  for (var _len2 = arguments.length, _ref2 = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
    _ref2[_key2 - 1] = arguments[_key2];
  }

  var _ref2$ = _ref2[0],
      options = _ref2$ === void 0 ? {} : _ref2$;

  try {
    // eslint-disable-next-line no-sync
    return _fs["default"].readFileSync(path, {
      encoding: getEncoding(options.buffer)
    });
  } catch (e) {
    return undefined;
  }
}