/// <reference types="node" />
export declare type Options<T extends boolean> = {
    /**
     * Return content as a Buffer. Default: `false`
     */
    buffer?: T;
};
declare type BufferArgs = [options: Options<true>];
declare type StringArgs = [options?: Options<false>];
export declare type Args = StringArgs | BufferArgs;
declare type ReturnContent<T> = T extends StringArgs ? string : Buffer;
export declare type ReturnValue<T> = ReturnContent<T> | undefined;
export declare function readFile<T extends Args>(path: string, ...[options]: T): Promise<ReturnValue<T>>;
export declare function readFileSync<T extends Args>(path: string, ...[options]: T): ReturnValue<T>;
export {};
