/**
 * List of valid HTML attributes that will be passed to first node of component or
 * to the node with an attribute 'attributes'.
 * Generated from scripts/fetch-attributes.js using
 * https://html.spec.whatwg.org/multipage/indices.html and
 * https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes
 *
 * @see https://jsfiddle.net/1r8czt2h/
 */

/* eslint-disable quote-props */
module.exports = {
  elementAttributes: {
    'A': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'download',
      'draggable',
      'enterkeyhint',
      'hidden',
      'href',
      'hreflang',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'ping',
      'popover',
      'referrerpolicy',
      'rel',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'target',
      'title',
      'translate',
      'type'
    ],
    'ABBR': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'ADDRESS': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'AREA': [
      'accesskey',
      'alt',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'coords',
      'dir',
      'download',
      'draggable',
      'enterkeyhint',
      'hidden',
      'href',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'ping',
      'popover',
      'referrerpolicy',
      'rel',
      'role',
      'shape',
      'spellcheck',
      'style',
      'tabindex',
      'target',
      'title',
      'translate'
    ],
    'ARTICLE': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'ASIDE': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'AUDIO': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'autoplay',
      'class',
      'contenteditable',
      'controls',
      'crossorigin',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'loop',
      'muted',
      'nonce',
      'popover',
      'preload',
      'role',
      'spellcheck',
      'src',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'B': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'BASE': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'href',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'target',
      'title',
      'translate'
    ],
    'BDI': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'BDO': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'BLOCKQUOTE': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'cite',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'BODY': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'onafterprint',
      'onbeforeprint',
      'onbeforeunload',
      'onhashchange',
      'onlanguagechange',
      'onmessage',
      'onmessageerror',
      'onoffline',
      'ononline',
      'onpagehide',
      'onpageshow',
      'onpopstate',
      'onrejectionhandled',
      'onstorage',
      'onunhandledrejection',
      'onunload',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'BR': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'BUTTON': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'disabled',
      'draggable',
      'enterkeyhint',
      'form',
      'formaction',
      'formenctype',
      'formmethod',
      'formnovalidate',
      'formtarget',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'name',
      'nonce',
      'popover',
      'popoverhidetarget',
      'popovershowtarget',
      'popovertoggletarget',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate',
      'type',
      'value'
    ],
    'CANVAS': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'height',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate',
      'width'
    ],
    'CAPTION': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'CITE': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'CODE': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'COL': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'span',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'COLGROUP': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'span',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'DATA': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate',
      'value'
    ],
    'DATALIST': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'DD': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'DEL': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'cite',
      'class',
      'contenteditable',
      'datetime',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'DETAILS': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'open',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'DFN': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'DIALOG': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'open',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'DIV': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'DL': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'DT': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'EM': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'EMBED': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'height',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'src',
      'style',
      'tabindex',
      'title',
      'translate',
      'type',
      'width'
    ],
    'FIELDSET': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'disabled',
      'draggable',
      'enterkeyhint',
      'form',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'name',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'FIGCAPTION': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'FIGURE': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'FOOTER': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'FORM': [
      'accept-charset',
      'accesskey',
      'action',
      'autocapitalize',
      'autocomplete',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enctype',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'method',
      'name',
      'nonce',
      'novalidate',
      'popover',
      'rel',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'target',
      'title',
      'translate'
    ],
    'H1': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'H2': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'H3': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'H4': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'H5': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'H6': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'HEAD': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'HEADER': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'HGROUP': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'HR': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'HTML': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'manifest',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'I': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'IFRAME': [
      'accesskey',
      'allow',
      'allowfullscreen',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'height',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'loading',
      'name',
      'nonce',
      'popover',
      'referrerpolicy',
      'role',
      'sandbox',
      'spellcheck',
      'src',
      'srcdoc',
      'style',
      'tabindex',
      'title',
      'translate',
      'width'
    ],
    'IMG': [
      'accesskey',
      'alt',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'crossorigin',
      'decoding',
      'dir',
      'draggable',
      'enterkeyhint',
      'fetchpriority',
      'height',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'ismap',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'loading',
      'nonce',
      'popover',
      'referrerpolicy',
      'role',
      'sizes',
      'spellcheck',
      'src',
      'srcset',
      'style',
      'tabindex',
      'title',
      'translate',
      'usemap',
      'width'
    ],
    'INPUT': [
      'accept',
      'accesskey',
      'alt',
      'autocapitalize',
      'autocomplete',
      'autofocus',
      'checked',
      'class',
      'contenteditable',
      'dir',
      'dirname',
      'disabled',
      'draggable',
      'enterkeyhint',
      'form',
      'formaction',
      'formenctype',
      'formmethod',
      'formnovalidate',
      'formtarget',
      'height',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'list',
      'max',
      'maxlength',
      'min',
      'minlength',
      'multiple',
      'name',
      'nonce',
      'pattern',
      'placeholder',
      'popover',
      'popoverhidetarget',
      'popovershowtarget',
      'popovertoggletarget',
      'readonly',
      'required',
      'role',
      'size',
      'spellcheck',
      'src',
      'step',
      'style',
      'tabindex',
      'title',
      'translate',
      'type',
      'value',
      'width'
    ],
    'INS': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'cite',
      'class',
      'contenteditable',
      'datetime',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'KBD': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'LABEL': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'for',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'LEGEND': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'LI': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate',
      'value'
    ],
    'LINK': [
      'accesskey',
      'as',
      'autocapitalize',
      'autofocus',
      'blocking',
      'class',
      'color',
      'contenteditable',
      'crossorigin',
      'dir',
      'disabled',
      'draggable',
      'enterkeyhint',
      'fetchpriority',
      'hidden',
      'href',
      'hreflang',
      'id',
      'imagesizes',
      'imagesrcset',
      'inert',
      'inputmode',
      'integrity',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'media',
      'nonce',
      'popover',
      'referrerpolicy',
      'rel',
      'role',
      'sizes',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate',
      'type'
    ],
    'MAIN': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'MAP': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'name',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'MARK': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'MATH': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'MENU': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'META': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'charset',
      'class',
      'content',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'http-equiv',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'media',
      'name',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'METER': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'high',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'low',
      'max',
      'min',
      'nonce',
      'optimum',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate',
      'value'
    ],
    'NAV': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'NOSCRIPT': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'OBJECT': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'data',
      'dir',
      'draggable',
      'enterkeyhint',
      'form',
      'height',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'name',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate',
      'type',
      'width'
    ],
    'OL': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'reversed',
      'role',
      'spellcheck',
      'start',
      'style',
      'tabindex',
      'title',
      'translate',
      'type'
    ],
    'OPTGROUP': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'disabled',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'label',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'OPTION': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'disabled',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'label',
      'lang',
      'nonce',
      'popover',
      'role',
      'selected',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate',
      'value'
    ],
    'OUTPUT': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'for',
      'form',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'name',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'P': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'PICTURE': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'PRE': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'PROGRESS': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'max',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate',
      'value'
    ],
    'Q': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'cite',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'RP': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'RT': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'RUBY': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'S': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'SAMP': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'SCRIPT': [
      'accesskey',
      'async',
      'autocapitalize',
      'autofocus',
      'blocking',
      'class',
      'contenteditable',
      'crossorigin',
      'defer',
      'dir',
      'draggable',
      'enterkeyhint',
      'fetchpriority',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'integrity',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nomodule',
      'nonce',
      'popover',
      'referrerpolicy',
      'role',
      'spellcheck',
      'src',
      'style',
      'tabindex',
      'title',
      'translate',
      'type'
    ],
    'SECTION': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'SELECT': [
      'accesskey',
      'autocapitalize',
      'autocomplete',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'disabled',
      'draggable',
      'enterkeyhint',
      'form',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'multiple',
      'name',
      'nonce',
      'popover',
      'required',
      'role',
      'size',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'SLOT': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'name',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'SMALL': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'SOURCE': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'height',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'media',
      'nonce',
      'popover',
      'role',
      'sizes',
      'spellcheck',
      'src',
      'srcset',
      'style',
      'tabindex',
      'title',
      'translate',
      'type',
      'width'
    ],
    'SPAN': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'STRONG': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'STYLE': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'blocking',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'media',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'SUB': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'SUMMARY': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'SUP': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'SVG': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'TABLE': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'TBODY': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'TD': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'colspan',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'headers',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'rowspan',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'TEMPLATE': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'TEXTAREA': [
      'accesskey',
      'autocapitalize',
      'autocomplete',
      'autofocus',
      'class',
      'cols',
      'contenteditable',
      'dir',
      'dirname',
      'disabled',
      'draggable',
      'enterkeyhint',
      'form',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'maxlength',
      'minlength',
      'name',
      'nonce',
      'placeholder',
      'popover',
      'readonly',
      'required',
      'role',
      'rows',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate',
      'wrap'
    ],
    'TFOOT': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'TH': [
      'abbr',
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'colspan',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'headers',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'rowspan',
      'scope',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'THEAD': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'TIME': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'datetime',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'TITLE': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'TR': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'TRACK': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'default',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'kind',
      'label',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'src',
      'srclang',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'U': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'UL': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'VAR': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ],
    'VIDEO': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'autoplay',
      'class',
      'contenteditable',
      'controls',
      'crossorigin',
      'dir',
      'draggable',
      'enterkeyhint',
      'height',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'loop',
      'muted',
      'nonce',
      'playsinline',
      'popover',
      'poster',
      'preload',
      'role',
      'spellcheck',
      'src',
      'style',
      'tabindex',
      'title',
      'translate',
      'width'
    ],
    'WBR': [
      'accesskey',
      'autocapitalize',
      'autofocus',
      'class',
      'contenteditable',
      'dir',
      'draggable',
      'enterkeyhint',
      'hidden',
      'id',
      'inert',
      'inputmode',
      'is',
      'itemid',
      'itemprop',
      'itemref',
      'itemscope',
      'itemtype',
      'lang',
      'nonce',
      'popover',
      'role',
      'spellcheck',
      'style',
      'tabindex',
      'title',
      'translate'
    ]
  },

  // Safelist and blacklist attributes will be applied to all tags

  // Add additional attributes, use '*' in the end to check by startsWith
  // Example: 'start-with-*'
  safelistAttributes: [
    'data-*',
    'aria-*'
  ],

  // Skip this attributes
  blacklistAttributes: []
};
