'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parseAttr = parseAttr;
exports.stringifyAttr = stringifyAttr;
function parseAttr(attrStr, rule) {
    rule = rule || {};
    var delimiter = rule.delimiter;
    var keyDelimiter = rule.keyDelimiter;
    if (!delimiter && !keyDelimiter) {
        return attrStr;
    }

    var attrValues = delimiter ? attrStr.split(delimiter) : [attrStr];
    if (!keyDelimiter) {
        return attrValues;
    }

    var attrDict = {};
    attrValues.forEach(function (attrKeyValue) {
        // We need to split attrKeyValue by keyDelimiter only once.
        // Therefore we use match() + slice() instead of split()

        var match = attrKeyValue.match(keyDelimiter);
        if (!match) {
            return;
        }

        var attrKey = attrKeyValue.slice(0, match.index);
        if (!attrKey) {
            return;
        }

        var attrValue = attrKeyValue.slice(match.index + match[0].length) || '';
        var attrCombinedValue = attrDict[attrKey];

        if (attrCombinedValue) {
            if (!Array.isArray(attrCombinedValue)) {
                attrCombinedValue = [attrCombinedValue];
            }
            attrCombinedValue.push(attrValue);
        } else {
            attrCombinedValue = attrValue;
        }

        attrDict[attrKey] = attrCombinedValue;
    });

    return attrDict;
}

function stringifyAttr(attr, rule) {
    rule = rule || {};
    var delimiter = (rule.glue || rule.delimiter || '').toString();
    var keyDelimiter = (rule.keyGlue || rule.keyDelimiter || '').toString();

    if (typeof attr === 'string') {
        return attr;
    }

    if (Array.isArray(attr)) {
        return attr.join(delimiter);
    }

    var attrKeyValues = [];
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
        var _loop = function _loop() {
            var attrName = _step.value;

            var attrCombinedValue = Array.isArray(attr[attrName]) ? attr[attrName] : [attr[attrName]];
            attrCombinedValue.forEach(function (attrValue) {
                attrKeyValues.push(attrName + keyDelimiter + attrValue);
            });
        };

        for (var _iterator = Object.keys(attr)[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            _loop();
        }
    } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
    } finally {
        try {
            if (!_iteratorNormalCompletion && _iterator.return) {
                _iterator.return();
            }
        } finally {
            if (_didIteratorError) {
                throw _iteratorError;
            }
        }
    }

    return attrKeyValues.join(delimiter);
}