"use strict";

exports.__esModule = true;
var _exportNames = {
  parse: true,
  parseJSONValue: true,
  parseJSONObject: true,
  parseJSONArray: true,
  parseString: true
};
exports.parse = parse;
exports.parseJSONValue = parseJSONValue;
exports.parseJSONObject = parseJSONObject;
exports.parseJSONArray = parseJSONArray;
exports.parseString = parseString;

var _typesJson = require("types-json");

Object.keys(_typesJson).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  exports[key] = _typesJson[key];
});

function parse(text, isType) {
  if (text) {
    try {
      var json = JSON.parse(text);

      if (isType(json)) {
        return json;
      } else {
        return undefined;
      }
    } catch (err) {
      return undefined;
    }
  } else {
    return undefined;
  }
}

function parseJSONValue(text) {
  return parse(text, _typesJson.isJSONValue);
}

function parseJSONObject(text) {
  return parse(text, _typesJson.isJSONObject);
}

function parseJSONArray(text) {
  return parse(text, _typesJson.isJSONArray);
}

function parseString(text) {
  return parse(text, _typesJson.isString);
}